/*
//@ FILE_NAME:	   cc_tables.h
//@ FACILITY:	   EM486
//@ AUTHORS:	   John Yates
//@ CREATION_DATE: 16 August 1995
//@ MODIFIED_DATE: 16 August 1995
//@ VERSION:	   0.0
//@ COPYRIGHT:	   COPYRIGHT (c) 1995 BY DIGITAL EQUIPMENT CORPORATION,
//@ COPYRIGHT:	   MAYNARD, MASSACHUSETTS.
//@ COPYRIGHT:	   ALL RIGHTS RESERVED.
//#+
//  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
//  ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
//  INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
//  COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
//  OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
//  TRANSFERRED.
//
//  THE INFORMATION IN THIS SOFTWARE IS	 SUBJECT TO CHANGE WITHOUT NOTICE
//  AND SHOULD	NOT  BE	 CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPEMENT
//  CORPORATION.
//
//  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
//  SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
//#-
*/

#ifndef __CCTABLES__
#define __CCTABLES__

// Size of a CC state decode table (in bytes)
# define CC_TABLE_SIZE	44

# define CC_PREDIATE_STRINGS		\
			"C|Z",		\
			"Partial?",	\
			"Z",		\
			"C",		\
			"V",		\
			"All CCs",	\
			"N",		\
			"P",		\
			"A",		\
			"N%V",		\
			"(N%V)|Z"

# if defined(ASAXP)

/* Condition code routine table offsets */

#ifdef linux
/* gas doesn't support .struct directive, so we have to do it another way */
	CC_be   =       0
	CC_state =      4
	CC_z    =       8
	CC_c    =       12
	CC_v    =       16
	CC_all  =       20
	CC_n    =       24
	CC_p    =       28
	CC_a    =       32
	CC_l    =       36
	CC_le   =       40

#else /* !linux */

	.struct	0
CC_be:	.long	1
CC_state: .long	1
CC_z:	.long	1
CC_c:	.long	1
CC_v:	.long	1
CC_all:	.long	1
CC_n:	.long	1
CC_p:	.long	1
CC_a:	.long	1
CC_l:	.long	1
CC_le:	.long	1

#endif /* linux */

#  define CC_TABLE_INIT(opcd_s, state)		\
	.long	CC_##opcd_s##_be	;	\
	.long	CC_STATE_##state	;	\
	.long	CC_##opcd_s##_z		;	\
	.long	CC_##opcd_s##_c		;	\
	.long	CC_##opcd_s##_v		;	\
	.long	CC_##opcd_s##_all	;	\
	.long	CC_##opcd_s##_n		;	\
	.long	CC_##opcd_s##_p		;	\
	.long	CC_##opcd_s##_a		;	\
	.long	CC_##opcd_s##_l		;	\
	.long	CC_##opcd_s##_le	;

// Condition code state flags
#  define CC_STATE_ONLY_C		+1
#  define CC_STATE_ALL_BUT_C		 0
#  define CC_STATE_ONLY_C_AND_V		-1
#  define CC_STATE_ALL			-2

// Table relationships for instructions with Byte, Word and Long variants
#  define CC_TABLE_OFFSET_B		0
#  define CC_TABLE_OFFSET_W		CC_TABLE_SIZE
#  define CC_TABLE_OFFSET_L		(CC_TABLE_SIZE*2)

// Table relationships with sub-decode group 0 (ADD/SUB/CMP/AND/OR/XOR/ADC/SBB)
#  define CC_OFFSET_FROM_SUB_TO_SBB1	(+CC_TABLE_SIZE*3)	/* =+132 */
#  define CC_OFFSET_FROM_SUB_TO_ADD	(+CC_TABLE_SIZE*6)	/* =+264 */
#  define CC_OFFSET_FROM_SUB_TO_LOGICAL	(-CC_TABLE_SIZE*3)	/* =-132 */

# endif
#endif // ndef __CCTABLES__
