/*
//@ FILE_NAME:	   run486.h
//@ FACILITY:	   EM486
//@ AUTHORS:	   Luther Johnson
//@ CREATION_DATE: 1 September 1994
//@ MODIFIED_DATE: 1 September 1994
//@ VERSION:	   0.0
//@ COPYRIGHT:	   COPYRIGHT (c) 1994 BY DIGITAL EQUIPMENT CORPORATION,
//@ COPYRIGHT:	   MAYNARD, MASSACHUSETTS.
//@ COPYRIGHT:	   ALL RIGHTS RESERVED.
//#+
//  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
//  ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
//  INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
//  COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
//  OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
//  TRANSFERRED.
//
//  THE INFORMATION IN THIS SOFTWARE IS	 SUBJECT TO CHANGE WITHOUT NOTICE
//  AND SHOULD	NOT  BE	 CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPEMENT
//  CORPORATION.
//
//  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
//  SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
//#-
*/


#ifndef _RUN486_H_
#define _RUN486_H_

/***********************************************************
/* Support for #including this header into C, C++ and Alpha
/* assembly contexts.  The scheme depends on the fact that
/* C and C++ perform natural alignment of fields in structs
/* and that asaxp does the same for .byte/.word/.long/.quad
/* directives (that is if no .align 0 is in effect).
/***********************************************************/

#if defined(ASAXP)

#ifdef linux
/* Linux doesn't support assembly structs; we have to do it a different way */
# define STRUCT16(type_name) \
	structbase = 0

# define _ByTe_(x) x = structbase ; structbase = structbase + 1;
# define _WoRd_(x) x = structbase ; structbase = structbase + 2;
# define _LoNg_(x) x = structbase ; structbase = structbase + 4;
# define _QuAd_(x) x = structbase ; structbase = structbase + 8;
# define _QuAdS_(x, n) x = structbase ; structbase = structbase + (n * 8);

# define END16(size_name, type_name)                      \
	_##size_name = structbase ;                     \
		structbase = structbase + ((16-(_##size_name&0xF))&0xF) ; \
	size_name = structbase


#else /* !linux */


# define STRUCT16(type_name) \
	.struct	0

# define _ByTe_(x) x:	.##byte	1;
# define _WoRd_(x) x:	.##word	1;
# define _LoNg_(x) x:	.##long	1;
# define _ULoNg_(x) x:	.##long	1;
# define _QuAd_(x) x:	.##quad	1;
# define _QuAdS_(x, n) x:	.##quad 1 ; .space ((n)-1)*8;

# define END16(size_name, type_name)			  \
	_##size_name:					; \
		.space ((16-(_##size_name&0xF))&0xF)	; \
	size_name:

#endif /* linux */

#else

# if defined(__cplusplus)
#  define STRUCT16(type_name) \
	struct type_name {
# else
#  define STRUCT16(type_name) \
	typedef struct {
# endif

# define _ByTe_(x) char x;
# define _WoRd_(x) short x;
# define _LoNg_(x) int x;
# define _ULoNg_(x) unsigned int x;
# ifdef _WIN32
#  define _QuAd_(x) signed __int64 x;
#  define _QuAdS_(x, n) signed __int64 x[n];
# else
#  define _QuAd_(x) long int x;
#  define _QuAdS_(x, n) long int x[n];
# endif
# if defined(__cplusplus)
#  define END16(size_name, type_name) \
	};
# else
#  define END16(size_name, type_name) \
	} type_name;
# endif

#endif

/***************************************************************/
/* This is the structure of an entry in the SEGMENTS array. We */
/* define it here because defining it within the EM486_Context */
/* structure in this multi-lingual environment is unthinkable. */
/***************************************************************/

#if defined(ASAXP)
# define SEG_SELECTOR	0
# define SEG_OFFSET	4
#else
# if defined(__cplusplus)
struct EM486_Segment_State {
    _LoNg_( SEG_SELECTOR ) /* User visible selector; high 2 bytes kept clean */
    _LoNg_( SEG_OFFSET )   /* Offset when used as an address prefix (hidden) */
    };
# endif
#endif

/* Segment selector values. */
#define TEB_READ_WRITE_SEGMENT_SELECTOR		0x38
#define FLAT_READ_WRITE_SEGMENT_SELECTOR	0x23
#define FLAT_READ_EXECUTE_SEGMENT_SELECTOR	0x1b
#define UNMAPPED_SEGMENT_SELECTOR		0x00

#include "cc_tables.h"

/***********************************************************/
/* CONTEXT area: per interpreter thread structure corres-  */
/*		 ponding to an x86 in execution; allocated */
/*		 within the variable portion of a CFRAME   */
/*		 procedure's stack frame		   */
/***********************************************************/

STRUCT16( EM486_Context )

/* All caches are 4-way set associative, with true LRU replacement. Each */
/* set occupies exactly 1 32B EV4 cache line; cache entries are aligned	 */
/* quadwords. The number of sets within a cache must be a power of 2;	 */
/* and to satify the 256 byte alignment of the floating point stack (see */
/* below) the minimum size is 8 sets.					 */


	/* 64 sets: cache lines 0 through 63, bytes 0 through 2047	  */
	/* Cache of x86 instruction properties				  */
	/* Each cache entry is a quadword laid out as follows:		  */
	/*	bits<63:32>	Raw data (depends on opcode)		  */
	/*	bits<31:0>	Subject x86 address			  */
	/* +++++ Since the x86 address is actually only 31 bits,	  */
	/* +++++ we could use the high bit of the x86 address as a flag.  */
	/* +++++ This would allow 2 entries per x86 instruction, which	  */
	/* +++++ is just what we need to profile conditional branches.	  */
#define cPROP_SHIFT 6
#define cPROP_SETS (1 << cPROP_SHIFT)
#define cPROP_MASK ((1 << cPROP_SHIFT) - 1)
_QuAdS_( cPROP, cPROP_SETS*4 )		/* Must be at offset 0 */


	/* 64 sets: cache lines 64 through 127, bytes 2048 through 4095	  */
	/* Cache of computed jmp/call edges				  */
	/* Each cache entry is a quadword laid out as follows:		  */
	/*	bits<63:32>	Source x86 address			  */
	/*	bits<31:0>	Target x86 address			  */
#define cEDGE_SHIFT 6
#define cEDGE_SETS (1 << cEDGE_SHIFT)
#define cEDGE_MASK (cEDGE_SETS - 1)
_QuAdS_( cEDGE, cEDGE_SETS*4 )


	/* 32 sets: cache lines 128 through 159, bytes 4096 through 5119  */
	/* Cache of jmp/call targets <-> Translated code addresses	  */
	/* Each cache entry is a quadword laid out as follows:		  */
	/*	bits<63:33>	Translation, 0 if known none exists	  */
	/*	bit<32>		0 if never called, 1 if at least 1 call	  */
	/*	bits<31:7,1:0>	x86 address (i.e., tag w/o index bits)	  */
	/*	bits<6:2>	Small counter of # times we transferred	  */
	/*			to the target.  Counts *down*, so 0 here  */
	/*			means a true count of 32, 31 means 1	  */
#define cTARGET_SHIFT 5
#define cTARGET_SETS (1 << cTARGET_SHIFT)
#define cTARGET_MASK (cTARGET_SETS - 1)
_QuAdS_( cTARGET, cTARGET_SETS*4 )

#define TCNT_BIT_POS 2
#define TCNT_MASK (cTARGET_MASK<<TCNT_BIT_POS)


/* FP area is 8*16 = 128 bytes = 4 EV4 cache lines, 2 EV5 or EV6 lines */

			/* Cache line 160, bytes 5120 through 5151 */
_QuAd_( rF0 )	/* FP stack entries, 8 bytes each			 */
_QuAd_( rF1 )	/*	(FP stack comes first to simplify allocating the */
_QuAd_( rF2 )	/*	context record while satisfying the 0 MOD 128	 */
_QuAd_( rF3 )	/*	alignment expected by the FSP manipulation code) */

			/* Cache line 161, bytes 5152 through 5183 */
_QuAd_( rF4 )
_QuAd_( rF5 )
_QuAd_( rF6 )
_QuAd_( rF7 )

			/* Cache line 162, bytes 5184 through 5215 */
_QuAd_( rF8 )	/* Guard word and initial target of FSP			 */
#define	rUEA_NXTJMP	rF8
_QuAd_( rFTMP0 )
#define rUEA_T0		rFTMP0
_QuAd_( rFTMP1 )
#define	rUEA_T1		rFTMP1
_QuAd_( rFPCW )	/* FP Control Word					 */

			/* Cache line 163, bytes 5216 through 5247 */
/* EV4 cache line written and read back during an FP library call	 */
_LoNg_( rFC_RA )
#define	rUEA_SEGOFF	rFC_RA
_LoNg_( rFC_NXTEIP )
#define	rUEA_CACHE_SET	rFC_NXTEIP
_QuAd_( rFC_QUAD )
#define rUEA_QUAD	rFC_QUAD
_QuAd_( rCALL_SITE_CACHE )	/* Pointer to per call-site lookup cache element */
_QuAd_( rFPSW ) /* FP Status Word					 */


			/* Cache line 164, bytes 5248 through 5279 */
	/* This first line is written and later read back in the code that
	 * maintains the local caches in front of the profile tables
	 */
_QuAd_( rSCCS )	/* Save area for active CC state when calling the OCCx */
_QuAd_( rSCCD ) /* and profiling routines. */
_LoNg_( rSCCR )
_LoNg_( rFSP )
_LoNg_( rEAX )	/* x86 32-bit integer register values */
_LoNg_( rEBX )

			/* Cache line 165, bytes 5280 through 5311 */
_LoNg_( rECX )
_LoNg_( rEDX )
_LoNg_( rEBP )
_LoNg_( rESP )
_LoNg_( rESI )
_LoNg_( rEDI )
_LoNg_( rEIP )
_LoNg_( rEFLAGS ) /* x86 EFLAGS image */

			/* Cache line 166, bytes 5312 through 5343 */
_LoNg_( rDF )	/* Internal to EM486, holds D flag.  (Loaded upon entry from
		   rEFLAGS, and saved into rEFLAGS upon exit.) The contents of
		   rDF is -1 (DF=1 / backward) or 1 (DF=0 / forward), and can
		   be used as the address increment in the string routines. */

_LoNg_( rIFID )	/* Holds IF and ID flag bits
		   Not used in interpreter (yet), but may be set and read */

_LoNg_( rFS_TEB_ADDRESS ) /* Inviolate allocateX86Context() FS/TEB values */
_LoNg_( rFS_TEB_SELECTOR )

/* x86 segment registers (hidden offsets & selectors) in Intel ordering */
#define rSEGMENTS rES
_LoNg_( rES )		/* sreg3 = 000 */
_LoNg_( rES_OFF )
_LoNg_( rCS )		/* sreg3 = 001 */
_LoNg_( rCS_OFF )

			/* Cache line 167, bytes 5344 through 5375 */
_LoNg_( rSS )		/* sreg3 = 010 */
_LoNg_( rSS_OFF )
_LoNg_( rDS )		/* sreg3 = 011 */
_LoNg_( rDS_OFF )
_LoNg_( rFS )		/* sreg3 = 100 */
_LoNg_( rFS_OFF )
_LoNg_( rGS )		/* sreg3 = 101 */
_LoNg_( rGS_OFF )


			/* Cache line 168, bytes 5376 through 5407 */
/* Address of dispatch tables for decoding a 16 bit prefix of the i-stream
 * prefix in various contexts.  These 8 longwords reside within a single EV4
 * cache-line that is read every time through the main dispatch loop; hence
 * there should be NO written fields anywhere within the line.
 */
_LoNg_( rDT0x07 )	/* 32 bit addressing, 32 bit word size, 2 byte opcode */
_LoNg_( rDT0x06 )	/* 32 bit addressing, 32 bit word size, 1 byte opcode */
_LoNg_( rDT0x05 )	/* 32 bit addressing, 16 bit word size, 2 byte opcode */
_LoNg_( rDT0x04 )	/* 32 bit addressing, 16 bit word size, 1 byte opcode */
_LoNg_( rDT0x03 )	/* 16 bit addressing, 32 bit word size, 2 byte opcode */
_LoNg_( rDT0x02 )	/* 16 bit addressing, 32 bit word size, 1 byte opcode */
_LoNg_( rDT0x01 )	/* 16 bit addressing, 16 bit word size, 2 byte opcode */
_LoNg_( rDT0x00 )	/* 16 bit addressing, 16 bit word size, 1 byte opcode */

			/* Cache line 169, bytes 5408 through 5439 */
/* These second 8 longwords reside within an EV4 cache-line that is written
 * every time through the main dispatch loop.  Minimize read accesses.
 * CAUTION: rOCCS and rOCCD must have true quadword alignment.
 */
_QuAd_( rOCCS )		/* Pushed state for lazy CC evaluation; used to */
_QuAd_( rOCCD )		/* resolve CCs that cannot be computed from the */
_LoNg_( rOCCR )		/* active state in CCS/CCD/CCR registers */
_LoNg_( rISTART )	/* Instruction's true address, unmodified by prefixes */
_LoNg_( rREP )		/* REP state: 0 = none / 0xff = REPE / -256 = REPNE */
#define	rNOTE_UEA_SAVE_SEGOFF rREP

_LoNg_( rCC_FWD_SAVE )	/* Saved copies of ERA during CC_forward_x() calls */
#define	rUEA_T2		rCC_FWD_SAVE
#define	rFP_INIT_SAVE	rCC_FWD_SAVE

			/* Cache line 170, bytes 5440 through 5471 */
_LoNg_( rCC_ALL_SAVE )	/* Saved copies of ERA during CC_xxx_all() calls */
#define	rUEA_EA		rCC_ALL_SAVE
_LoNg_( rCC_EXTR_SAVE )	/* Saved copies of ERA during CC_extract() calls */
#define	rUEA_ERA	rCC_EXTR_SAVE

/* Pointers to routines for maintaining the address-space-wide profile tables
 */
_LoNg_( pProfileNoteComputedEdge )	/* ( source-va, target-va )	*/
_LoNg_( pProfileGetTranslation )	/* translate( target-va, call-flag )		*/
_LoNg_( pProfileUpdate )		/* update( target-va, call-flag, count )	*/
_LoNg_( pProfileBumpCount )		/* bump( istart-va, count )			*/
_LoNg_( pProfileNoteCount )		/* note( istart-va )				*/

#ifdef Wx86
/* Pointers for Wx86 environment
 */
_LoNg_( pNative )	/* Wx86DispatchBop( BOPINSTR *Bop ) */
#endif

/* Pointers to routines in DPML (the Digital Portable Math Library)
 */
_LoNg_( pCONTROLFP )
_LoNg_( pEXPM1 )
_LoNg_( pLOG2 )
_LoNg_( pATAN2 )
_LoNg_( pREMAINDER )
_LoNg_( pFMOD )
_LoNg_( pLOG1P )
_LoNg_( pSINCOS )
_LoNg_( pSQRT )
    

_LoNg_( rCACHES_ARE_STALE ) /* Causes caches indexed by x86 PC to be purged */

_LoNg_( rCONTEXTS_NEXT ) /* Invasive doubly linked list through all contexts */
_LoNg_( rCONTEXTS_PREV )

_LoNg_( rSTATUS )	/* Exit code, EM486 is returning to its caller */
_LoNg_( rCONTINUABLE )	/* If rSTATUS != 0, this is 0 or EXCEPTION_NONCONTINUABLE */

#ifdef EM86_RUNTIME
_LoNg_( RegsHomed )     /* flag to tell us if regs are homed or not */
_LoNg_( Running )       /* flag to tell us if interpreter is running */
_LoNg_( StopOrTrace )	/* Logical "or" of all stop/trace flags */
_LoNg_( StopInterp )    /* flag to tell interpreter to stop at next intr. */
_LoNg_( I_count )       /* Count of instructions run */
_LoNg_( TraceIndex )
_QuAd_( TracePtr )
#endif

#if defined(ASAXP)
/* Round up to a quadword boundary; all subsequent allocations will be quads
 * This is done explicitly to work around an apparent assembler bug with the
 * default alignment of .quad
 */
#ifdef linux
	_END_LONGS = structbase
	structbase = structbase + ( ( 8 - (_END_LONGS & 0x7) ) & 0x7 )
#else /* !linux */
_END_LONGS:
	    .space ( ( 8 - (_END_LONGS & 0x7) ) & 0x7 )
#endif /* linux */
#endif

/* Storage for constants pushed onto FP stack by FLDx instructions.
 * (Order in memory parallels opcode encoding.)
 */
_QuAd_( rFCON1 )	/* d9 e8	FLD1	0x3ff0000000000000	*/
_QuAd_( rFCONL2T )	/* d9 e9	FLDL2T	0x400a934f0979a371	*/
_QuAd_( rFCONL2E )	/* d9 ea	FLDL2E	0x3ff71547652b82fe	*/
_QuAd_( rFCONPI )	/* d9 eb	FLDPI	0x400921fb54442d18	*/
_QuAd_( rFCONLG2 )	/* d9 ec	FLDLG2	0x3fd34413509f79ff	*/
_QuAd_( rFCONLN2 )	/* d9 ed	FLDLN2	0x3fe62e42fefa39ef	*/
_QuAd_( rFNOFRAC )	/*		2^52	0x4330000000000000	*/
_QuAd_( rFPOINT25 )	/*		0.25	0x3fd0000000000000	*/
_QuAd_( rFCON22 )	/*		22.0	0x4036000000000000	*/


/* Head of the Push-Down-List of Interpreter Activation frames.	 The value
 * is equal to the contents of s6/fp for that activation.  Bottom of the
 * list is denoted by a null.
 */
_QuAd_( rIAPDL )



/* The WinNT Thread-Environment-Block referenced by the x86's FS selector
 */
#ifndef ASAXP
    struct TEB {
#endif
	_LoNg_( ExceptionList )
	_LoNg_( StackBase )
	_LoNg_( StackLimit )
	_LoNg_( SubSystemTib )
	_LoNg_( Version )
	_LoNg_( ArbitraryUserPointer )
#ifdef ASAXP
	_LoNg_( Self )
#else
	struct TEB *Self;
#endif
	_LoNg_( Unknown1 )
	_LoNg_( Unknown2 )
	_LoNg_( Unknown3 )
	_LoNg_( Unknown4 )
	_LoNg_( TlsArrayPointer )
    	_LoNg_( PebPointer )
#ifndef ASAXP
    } teb;
#endif

/* Exception codes used to report interpreted-to-translated and
 * translated-to-interpreted transitions to external trace program
 */
#define EM486_TRACE_CONTROL \
_LoNg_( rTRACE_INTERP_CALL )	/* Trace interpreted to interpreted calls */ \
_LoNg_( rTRACE_ENTER_XLATED_CJ )/* Entry to translated at a CALL or JUMP */ \
_LoNg_( rTRACE_ENTER_XLATED_N )	/* Entry to translated after NATIVE_CALL */ \
_LoNg_( rTRACE_ENTER_XLATED_R )	/* Entry to translated at a RET */ \
_LoNg_( rTRACE_LEAVE_XLATED_J ) /* Revert to interpreted at JUMP */ \
_LoNg_( rTRACE_LEAVE_XLATED_C ) /* Failed lookup_call_entry */ \
_LoNg_( rTRACE_LEAVE_XLATED_N ) /* Revert to interpreted at CALL, live CCs */ \
_LoNg_( rTRACE_LEAVE_XLATED_R )	/* No xlated return addr on shadow stack */ \
_LoNg_( rTRACE_LEAVE_XLATED_U )	/* Untranslatable instruction or behaviour */ \
_LoNg_( rTRACE_EXCEPT_REENTRY )	/* Completion of exception handling */

	EM486_TRACE_CONTROL


_LoNg_( rSTATS )		/* Pointer to the statistics structure */
_LoNg_( rINSTRS )		/* Per thread count of instructions */
_LoNg_( rENTRY_INSTRS )		/* rINSTRS at last entry to interpreter */
_LoNg_( rWATCH_VALUE )		/* Previous value of watch location */

/* Space for per CC state dispatch tables; current state is maintained by
 * the CCR register; tables accessed by desired predicate (see "cc_tables.h").
 * While master versions of these tables are initialized in "nt486.s" we
 * copy those tables to the context record to be able tocontrol the cache
 * collision effects.
 */

_LoNg_( cCC_start )		/* Dummy longword to mark start of cc tables */

#ifndef ASAXP
# define CC_DEFINE(name,state) \
	void* cCC_##name[CC_TABLE_SIZE >> 2];
#else
#ifdef linux
# define CC_DEFINE(name,state) \
  cCC_##name = structbase ; structbase = structbase + CC_TABLE_SIZE ;
#else /* !linux */
# define CC_DEFINE(name,state) \
  cCC_##name: .space CC_TABLE_SIZE - 4;	.long	1;
#endif /* linux */
#endif /* ASAXP */

#include "cc_opcodes.h"

#undef CC_DEFINE

END16( CONTEXTSZ, EM486_Context )


/* Define the collection of trace control codes as a struct.
 */
#ifndef ASAXP
    struct EM486_Trace_Control {
	EM486_TRACE_CONTROL
    };
#endif

/***********************************************************/
/* SFRAME:	interpreter shadow-stack frame		   */
/***********************************************************/


STRUCT16( EM486_Shadow_Stack_Frame )

_LoNg_( sfDLink )	/* Dynamic Link	  - points to previous shadow frame */
_LoNg_( sfRA )		/* Resume Address - points to a translated call site */
_LoNg_( sfEIP )		/* x86 EIP	  - used to validate sfRA at a return */
_LoNg_( sfESP )		/* x86 ESP	  - used to validate sfRA at a return */

/* Must keep shadow stack 16 byte aligned to adhere to Alpha calling standard. */

END16( SFFRAMESZ, EM486_Shadow_Stack_Frame )

/***********************************************************/
/* IFRAME:	interpreter activation frame		   */
/***********************************************************/


STRUCT16( EM486_Interpreter_Activation_Frame )


_QuAd_( iCONTEXT )	/* Pointer to thread's single context area */
_LoNg_( iSHADOW )	/* Bottom of this Alpha frame (restored on reentry) */
_LoNg_( iOLD_ESP )	/* ESP at time of latest ItoA transition */
_QuAd_( iIAPDL )	/* Previous interpreter activation (if any) */
_QuAd_( iESP )		/* x86 stack depth at creation of this Alpha frame */
_QuAd_( iUNWIND )	/* UnwindContext Pointer */
_QuAd_( iEXCEPT )	/* x86 ExceptionContext Pointer */

/* Alpha registers which are saved/restored */
_QuAd_( iRA )
_QuAd_( iS0 )
_QuAd_( iS1 )
_QuAd_( iS2 )
_QuAd_( iS3 )
_QuAd_( iS4 )
_QuAd_( iS5 )
_QuAd_( iFP )
_QuAd_( iF2 )
_QuAd_( iF3 )
_QuAd_( iF4 )
_QuAd_( iF5 )
_QuAd_( iF6 )
_QuAd_( iF7 )
_QuAd_( iF8 )
_QuAd_( iF9 )

#define iFC_RA_OUTER (iQUAD_TMP1+0)
#define	iFC_RA	     (iQUAD_TMP1+4)
_QuAd_( iQUAD_TMP1 )
_QuAd_( iQUAD_TMP2 )

/******************************************************************************/
/***									    ***/
/***	   ALL PRECEDING FIELDs COVERED BY INTERFACE VERSION NUMBER	    ***/
/***									    ***/
/******************************************************************************/


_QuAd_( iFCON1 )	/*	1.0	0x3ff0000000000000	*/
_QuAd_( iFCONLN2 )	/*	Ln(2)	0x3fe62e42fefa39ef	*/
_QuAd_( iFNOFRAC )	/*	2^52	0x4330000000000000	*/
_QuAd_( iFPOINT25 )	/*	0.25	0x3fd0000000000000	*/
#define	iPLUS_INFINITY iEXP_MASK /*	0x7ff0000000000000	*/
_QuAd_( iEXP_MASK )	/* 		0x7ff0000000000000	*/
_QuAd_( iINDEFINITE )	/* 		0xfff8000000000000	*/
_QuAd_( i800000000000000000 )	/*	0x0b1a2bc2ec500000	*/

_QuAd_( iFSP )
_QuAd_( iEAX )
_QuAd_( iECX )
_QuAd_( iEDX )
_QuAd_( iNXTQ_LO )
_QuAd_( iNXTQ_HI )
_QuAd_( iNXTJMP )
_QuAd_( iCCS )
_QuAd_( iCCD )
_QuAd_( iCCR )

_LoNg_( iCACHED_FPCW )	/* Provide access to FPCW without using CONTEXT */

_QuAdS_( iSpace_For_Sentinel_Shadow_Frame, 2 )

END16( IFRAMESZ, EM486_Interpreter_Activation_Frame )


/***********************************************************/
/* ProfileElement: Data in a ProfileEntry                  */
/***********************************************************/

STRUCT16( ProfileElement )

			/* CAUTION: first 2 entries must be address and translation */
			/*	    The assembly code in em486_first requires this. */
_LoNg_( peAddress )	/* x86 address to which this element corresponds */
_LoNg_( peTranslation )	/* Alpha address of corresponding translated code */
_LoNg_( peCount1 )	/* conditional branch:	branch taken */
			/* memory reference:	unaligned access */
_LoNg_( peCount2 )	/* conditional branch:	fell through */
_LoNg_( peTransferredTo )	/* call target:		transfers to count */

/* Must keep shadow stack 16 byte aligned to adhere to Alpha calling standard. */

END16( ProfileElementSize, ProfileElement )

#if !defined(ASAXP)
// Define real framesize for use by C and C++ code
#define IFRAMESZ ((sizeof(EM486_Interpreter_Activation_Frame)+15)&~15)
#endif

# if defined(ASAXP)

// The EM486_PROLOG macro below is called in various strange contexts
// (including building OPT on OSF/1 (aka Digital Unix)).  ASAXP on NT
// and OSF/1 do not seem to implement identical naming schemes for the
// Alpha registers.  In particular ASAXP on OSF/1 only allows a dollar
// sign to prefix a string of digits; that is it rejects a construct
// such as $s0 as a register identifier.  The following definitions
// are provided to allow EM486_PROLOG to be written using meaningful
// register names.

#ifndef s0
# define s0 $9
#endif
#ifndef s1
# define s1 $10
#endif
#ifndef s2
# define s2 $11
#endif
#ifndef s3
# define s3 $12
#endif
#ifndef s4
# define s4 $13
#endif
#ifndef s5
# define s5 $14
#endif
#ifndef ra
# define ra $26
#endif
#ifndef sp
# define sp $30
#endif

// This macro is provided to ensure that all code that logically must be
// able to unwind through an EM486 interpreter activation may include a
// a dummy prolog sequence identical to that executed by the interpreter
// activation.

#ifdef linux
// One difference for linux; gas uses "fp" rather than "$fp"
#define EM486_PROLOG( entry )	 	\
	.ent	entry			;\
	.frame	fp, IFRAMESZ, ra	;\
  entry:				;\
	lda	sp, -IFRAMESZ(sp)	;\
	stq	ra, iRA(sp)		;\
	stq	s0, iS0(sp)		;\
	stq	s1, iS1(sp)		;\
	stq	s2, iS2(sp)		;\
	stq	s3, iS3(sp)		;\
	stq	s4, iS4(sp)		;\
	stq	s5, iS5(sp)		;\
	stq	fp, iFP(sp)		;\
	stt	$f2, iF2(sp)		;\
	stt	$f3, iF3(sp)		;\
	stt	$f4, iF4(sp)		;\
	stt	$f5, iF5(sp)		;\
	stt	$f6, iF6(sp)		;\
	stt	$f7, iF7(sp)		;\
	stt	$f8, iF8(sp)		;\
	stt	$f9, iF9(sp)		;\
	trapb				;\
	mov	sp, fp			;\
	.prologue 0			;

#else /* !linux */

#define EM486_PROLOG( entry )	 	\
	.ent	entry			;\
	.frame	fp, IFRAMESZ, ra	;\
  entry:				;\
	lda	sp, -IFRAMESZ(sp)	;\
	stq	ra, iRA(sp)		;\
	stq	s0, iS0(sp)		;\
	stq	s1, iS1(sp)		;\
	stq	s2, iS2(sp)		;\
	stq	s3, iS3(sp)		;\
	stq	s4, iS4(sp)		;\
	stq	s5, iS5(sp)		;\
	stq	$fp, iFP(sp)		;\
	stt	$f2, iF2(sp)		;\
	stt	$f3, iF3(sp)		;\
	stt	$f4, iF4(sp)		;\
	stt	$f5, iF5(sp)		;\
	stt	$f6, iF6(sp)		;\
	stt	$f7, iF7(sp)		;\
	stt	$f8, iF8(sp)		;\
	stt	$f9, iF9(sp)		;\
	trapb				;\
	mov	sp, fp			;\
	.prologue 0			;

#endif /* linux */
# endif /* if defined(ASAXP) */

#endif /* #ifndef _RUN486_H_ */
